/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class WavPlayer {
    private Clip clip = null;
    private AudioInputStream audioStream = null;

    public WavPlayer(String s) throws Exception {
        this.audioStream = AudioSystem.getAudioInputStream(new BufferedInputStream(this.getClass().getResourceAsStream(s)));
        AudioFormat audioFormat = this.audioStream.getFormat();
        DataLine.Info info = new DataLine.Info(Clip.class, this.audioStream.getFormat(), (int)this.audioStream.getFrameLength() * audioFormat.getFrameSize());
        this.clip = (Clip)AudioSystem.getLine(info);
    }

    public boolean open() {
        if (this.clip != null && !this.clip.isOpen()) {
            try {
                System.setProperty("com.sun.speech.freetts.audio.AudioPlayer.openFailDelayMs", "100");
                System.setProperty("com.sun.speech.freetts.audio.AudioPlayer.totalOpenFailDelayMs", "30000");
                this.clip.open(this.audioStream);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(new JFrame(), "Veuillez couper toute autre source sonore.");
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public void close() {
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.close();
        }
    }

    public void play() {
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.start();
        }
    }

    public void stop() {
        if (this.clip != null && this.clip.isOpen()) {
            this.clip.stop();
        }
    }
}

